//############################################################
//
//	VdoCapture.cpp
//
//############################################################
#include "stdafx.h"
#include "SpeedDome.h"
#include "ControlDlg.h"
#include "SpeedDomeDoc.h"
#include "SpeedDomeView.h"
#include "VideoCapture.h"
#include "vfw.h"
#include "VideoMainCWnd.h"
#include "GlobalVar.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define	MAXVDODRIVERS	10

//########################################################################
// Enumerate the potential capture drivers and add the list to the Options
// menu.  This function is only called once at startup.
// Returns FALSE if no drivers are available.
//########################################################################

BOOL	VideoCapEnumerateDrivers(HWND hwnd)
{
UINT   DriverCount;
HWND   ghWndMain = NULL ;

char		achDeviceVersion[80] ;
char		achDeviceAndVersion[160] ;
UINT		uIndex ;
HMENU		hMenuSub;
unsigned	count;

DriverCount = 0 ;
hMenuSub = ::GetSubMenu (::GetMenu(hwnd),2);  // Options menu

count=::GetMenuItemCount(hMenuSub);

for (uIndex = 0 ; uIndex < MAXVDODRIVERS ; uIndex++) 
	{
    if (capGetDriverDescription(uIndex,
        (LPSTR)achDeviceAndVersion, sizeof(achDeviceAndVersion),
        (LPSTR)achDeviceVersion, sizeof(achDeviceVersion))) 
		{
        // Concatenate the device name and version strings
        lstrcat (achDeviceAndVersion, ",   ");
        lstrcat (achDeviceAndVersion, achDeviceVersion);

		::InsertMenu(hMenuSub,count+1,
			MF_STRING|MF_BYPOSITION|MF_ENABLED,
			IDM_VDO_DRIVER0 + uIndex,achDeviceAndVersion);
             
        DriverCount++;
		}
    else
        break;
	}

gDriverCount=DriverCount;
// Now refresh menu, position capture window, start driver etc
DrawMenuBar(ghWndMain) ;

return (DriverCount);
}





